/*
 * @(#)CERConnectionLiner.java  1.0  28. M�rz 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.diagram;

import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
import java.util.*;
import java.awt.geom.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.liner.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;

/**
 * A Liner that constrains a connection to two orthogonal lines.
 * The placement of the lines is dictated by the CEREntitySetFigure.
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 28. M�rz 2006 Created.
 */
public class CERConnectionLiner implements Liner, DOMStorable {
    
    /** Creates a new instance. */
    public CERConnectionLiner() {
    }
    
    @Override
    public Collection<Handle> createHandles(BezierPath path) {
        return null;
    }
    
    @Override
    public void lineout(ConnectionFigure figure) {
        BezierPath path = ((LineConnectionFigure) figure).getBezierPath();
        Connector start = figure.getStartConnector();
        Connector end = figure.getEndConnector();
        if (start == null || end == null || path == null) {
            return;
        }
        
        Point2D.Double sp = start.findStart(figure);
        Point2D.Double ep = end.findEnd(figure);
        
        path.clear();
        path.add(new BezierPath.Node(sp.x,sp.y));
        
        if (sp.x == ep.x || sp.y == ep.y) {
            path.add(new BezierPath.Node(ep.x,ep.y));
        } else {
            Rectangle2D.Double sb = ((DecoratedFigure) start.getOwner()).getDecorator().getBounds();
            Rectangle2D.Double eb = ((DecoratedFigure) end.getOwner()).getDecorator().getBounds();
            if (start.getOwner() instanceof CEREntitySetFigure) {
                int soutcode = sb.outcode(sp);
                if (soutcode == 0) {
                    soutcode = Geom.outcode(sb, eb);
                }
                if ((soutcode & (Geom.OUT_TOP | Geom.OUT_BOTTOM)) != 0) {
                    path.add(new BezierPath.Node(sp.x, ep.y));
                } else {
                    path.add(new BezierPath.Node(ep.x, sp.y));
                }
            } else {
                int eoutcode = eb.outcode(sp);
                if (eoutcode == 0) {
                    eoutcode = Geom.outcode(eb, sb);
                }
                if ((eoutcode & (Geom.OUT_TOP | Geom.OUT_BOTTOM)) != 0) {
                    path.add(new BezierPath.Node(ep.x, sp.y));
                } else {
                    path.add(new BezierPath.Node(sp.x, ep.y));
                }
            }
            /*
            Rectangle2D.Double sb = start.getBounds();
            Rectangle2D.Double eb = end.getBounds();
             
            int soutcode = sb.outcode(sp);
            if (soutcode == 0) {
                soutcode = Geom.outcode(sb, eb);
            }
            int eoutcode = eb.outcode(ep);
            if (eoutcode == 0) {
                eoutcode = Geom.outcode(eb, sb);
            }
             
            if ((soutcode & (Geom.OUT_TOP | Geom.OUT_BOTTOM)) != 0 &&
                    (eoutcode & (Geom.OUT_TOP | Geom.OUT_BOTTOM)) != 0) {
                path.add(new BezierPath.Node(sp.x, ep.y));
            } else {
                path.add(new BezierPath.Node(sp.x, ep.y));
            }
             */
            path.add(new BezierPath.Node(ep.x,ep.y));
        }
        
        path.invalidatePath();
    }
    
    @Override
    public void read(DOMInput in) {
    }
    
    @Override
    public void write(DOMOutput out) {
    }
    @Override
    public Liner clone() {
        try {
            return (Liner) super.clone();
        } catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }
}
